
DROP TABLE IF EXISTS `site_plugin_contact_departments`;
CREATE TABLE `site_plugin_contact_departments` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_show` int(1) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_phone` varchar(50) NOT NULL,
  `item_fax` varchar(50) NOT NULL,
  `item_email` varchar(100) NOT NULL,
  `item_email_template` varchar(100) NOT NULL,
  `item_email_autoresponder` varchar(100) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `module_id` (`module_id`,`item_show`,`item_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_contact_departments_lang`;
CREATE TABLE `site_plugin_contact_departments_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `item_address` text NOT NULL,
  `item_contact_pers` varchar(100) NOT NULL,
  `item_webpage` text NOT NULL,
  KEY `item_id` (`item_id`),
  KEY `lang_id_2` (`lang_id`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_contact_fields`;
CREATE TABLE `site_plugin_contact_fields` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_field` varchar(255) NOT NULL,
  `item_icon` varchar(50) NOT NULL,
  `item_type` varchar(30) NOT NULL,
  `item_required` int(1) NOT NULL,
  `item_size` int(2) NOT NULL,
  `item_size_lg` int(2) NOT NULL,
  `item_size_md` int(2) NOT NULL,
  `item_size_sm` int(2) NOT NULL,
  `item_size_xs` int(2) NOT NULL,
  `item_system` int(1) NOT NULL,
  `item_radio_new` int(1) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `module_id` (`module_id`,`item_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_contact_fields_lang`;
CREATE TABLE `site_plugin_contact_fields_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(3) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_error_msg` varchar(255) NOT NULL,
  `item_options` text NOT NULL,
  KEY `lang_id` (`lang_id`),
  KEY `item_id` (`item_id`),
  KEY `lang_id_2` (`lang_id`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_contact_messages`;
CREATE TABLE `site_plugin_contact_messages` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_department` int(11) NOT NULL,
  `item_code` varchar(32) NOT NULL,
  `item_file` int(1) NOT NULL,
  `item_file_file` varchar(255) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_new` int(1) NOT NULL,
  `item_replied` int(1) NOT NULL,
  `item_replied_date` int(11) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_email` varchar(255) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `item_subject` varchar(255) NOT NULL,
  `item_message` text,
  `item_anonymous` int(1) NOT NULL,
  `item_spam` int(1) NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_domain` varchar(255) NOT NULL,
  `log_agent` varchar(255) NOT NULL,
  `item_reply` text NOT NULL,
  `item_vars` text NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_department` (`item_department`,`module_id`,`item_new`,`item_replied`,`item_date`),
  KEY `item_department_2` (`item_department`,`module_id`,`item_new`,`item_replied`,`item_date`),
  KEY `item_spam` (`item_spam`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
